/* ppcpst.c */

/*
 *  Copyright (C) 2022-2024  Alan R. Baldwin
 *  Copyright (C) 2022-2024  Nick Downing
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 * Alan R. Baldwin
 * 721 Berkeley St.
 * Kent, Ohio  44240
 */

#include "asxxxx.h"
#include "ppc.h"

/*
 * Coding Banks
 */
struct	bank	bank[2] = {
    /*	The '_CODE' area/bank has a NULL default file suffix.	*/
    {	NULL,		"_CSEG",	NULL,		0,	0,	0,	0,	0	},
    {	&bank[0],	"_DSEG",	"_DS",		1,	0,	0,	0,	B_FSFX	}
};

/*
 * Coding Areas
 */
struct	area	area[2] = {
    {	NULL,		&bank[0],	"_CODE",	0,	0,	0,	A_1BYTE|A_BNK|A_CSEG	},
    {	&area[0],	&bank[1],	"_DATA",	1,	0,	0,	A_1BYTE|A_BNK|A_DSEG	}
};

/*
 * Basic Relocation Mode Definition
 *
 *	#define		R_NORM		0x0000		No Bit Positioning
 */
char	mode0[32] = {	/* R_NORM */
	'\200',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\220',	'\221',	'\222',	'\223',	'\224',	'\225',	'\226',	'\227',
	'\230',	'\231',	'\232',	'\233',	'\234',	'\235',	'\236',	'\237'
};

/*
 * Additional Relocation Mode Definitions
 *
 * Specification for the D (16-bit) mode:
 *
 *	#define		R_D		0x0100		No Bit Positioning
 */
char mode1[32] = {	/* R_D */
	'\200',	'\201',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 * Specification for the DS (16-bit, without lowest 2 bits) mode:
 *
 *	#define		R_DS		0x0200		No Bit Positioning
 */
char mode2[32] = {	/* R_DS */
	'\000',	'\001',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 * Specification for the LI (26-bit PCR, without lowest 2 bits) mode:
 *
 *	#define		R_LI		0x0200		No Bit Positioning
 */
char mode3[32] = {	/* R_LI */
	'\000',	'\001',	'\202',	'\203',	'\204',	'\205',	'\206',	'\207',
	'\210',	'\211',	'\212',	'\213',	'\214',	'\215',	'\216',	'\217',
	'\220',	'\221',	'\222',	'\223',	'\224',	'\225',	'\226',	'\227',
	'\230',	'\231',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 * Specification for the MFC0 (3-bit immediate) mode:
 *
 *	#define		R_MFC0		0x0400		No Bit Positioning
 */
char mode4[32] = {	/* R_MFC0 */
	'\200',	'\201',	'\202',	'\003',	'\004',	'\005',	'\006',	'\007',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};

/*
 * Specification for the SLL (5-bit immediate) mode:
 *
 *	#define		R_SLL		0x0500		Bit Positioning << 6
 */
char mode5[32] = {	/* R_SLL */
	'\206',	'\207',	'\210',	'\211',	'\212',	'\005',	'\006',	'\007',
	'\010',	'\011',	'\012',	'\013',	'\014',	'\015',	'\016',	'\017',
	'\020',	'\021',	'\022',	'\023',	'\024',	'\025',	'\026',	'\027',
	'\030',	'\031',	'\032',	'\033',	'\034',	'\035',	'\036',	'\037'
};


/*
 *     *m_def is a pointer to the bit relocation definition.
 *	m_flag indicates that bit position swapping is required.
 *	m_dbits contains the active bit positions for the output.
 *	m_sbits contains the active bit positions for the input.
 *
 *	struct	mode
 *	{
 *		char *	m_def;		Bit Relocation Definition
 *		a_uint	m_flag;		Bit Swapping Flag
 *		a_uint	m_dbits;	Destination Bit Mask
 *		a_uint	m_sbits;	Source Bit Mask
 *	};
 */
struct	mode	mode[6] = {
    {	&mode0[0],	0,	0xFFFFFFFF,	0xFFFFFFFF	},
    {	&mode1[0],	0,	0x0000FFFF,	0x0000FFFF	},
    {	&mode2[0],	0,	0x0000FFFC,	0x0000FFFC	},
    {	&mode3[0],	0,	0x03FFFFFC,	0x03FFFFFC	},
    {	&mode4[0],	0,	0x00000007,	0x00000007	},
    {	&mode5[0],	1,	0x000007C0,	0x0000001F	}
};

/*
 * Array of Pointers to mode Structures
 */
struct	mode	*modep[16] = {
	&mode[0],	&mode[1],	&mode[2],	&mode[3],
	&mode[4],	&mode[5],	NULL,		NULL,
	NULL,		NULL,		NULL,		NULL,
	NULL,		NULL,		NULL,		NULL
};

/*
 * Mnemonic Structure
 */
struct	mne	mne[] = {

	/* assembler */

    {	NULL,	".enabl",	S_OPTN,		0,	O_ENBL	},
    {	NULL,	".dsabl",	S_OPTN,		0,	O_DSBL	},
    {	NULL,	".page",	S_PAGE,		0,	0	},
    {	NULL,	".title",	S_HEADER,	0,	O_TITLE	},
    {	NULL,	".sbttl",	S_HEADER,	0,	O_SBTTL	},
    {	NULL,	".module",	S_MODUL,	0,	0	},
    {	NULL,	".include",	S_INCL,		0,	I_CODE	},
    {	NULL,	".incbin",	S_INCL,		0,	I_BNRY	},
    {	NULL,	".area",	S_AREA,		0,	0	},
    {	NULL,	".psharea",	S_AREA,		0,	O_PSH	},
    {	NULL,	".poparea",	S_AREA,		0,	O_POP	},
    {	NULL,	".bank",	S_BANK,		0,	0	},
    {	NULL,	".org",		S_ORG,		0,	0	},
    {	NULL,	".radix",	S_RADIX,	0,	0	},
    {	NULL,	".globl",	S_GLOBL,	0,	0	},
    {	NULL,	".local",	S_LOCAL,	0,	0	},
    {	NULL,	".if",		S_CONDITIONAL,	0,	O_IF	},
    {	NULL,	".iff",		S_CONDITIONAL,	0,	O_IFF	},
    {	NULL,	".ift",		S_CONDITIONAL,	0,	O_IFT	},
    {	NULL,	".iftf",	S_CONDITIONAL,	0,	O_IFTF	},
    {	NULL,	".ifdef",	S_CONDITIONAL,	0,	O_IFDEF	},
    {	NULL,	".ifndef",	S_CONDITIONAL,	0,	O_IFNDEF},
    {	NULL,	".ifgt",	S_CONDITIONAL,	0,	O_IFGT	},
    {	NULL,	".iflt",	S_CONDITIONAL,	0,	O_IFLT	},
    {	NULL,	".ifge",	S_CONDITIONAL,	0,	O_IFGE	},
    {	NULL,	".ifle",	S_CONDITIONAL,	0,	O_IFLE	},
    {	NULL,	".ifeq",	S_CONDITIONAL,	0,	O_IFEQ	},
    {	NULL,	".ifne",	S_CONDITIONAL,	0,	O_IFNE	},
    {	NULL,	".ifb",		S_CONDITIONAL,	0,	O_IFB	},
    {	NULL,	".ifnb",	S_CONDITIONAL,	0,	O_IFNB	},
    {	NULL,	".ifidn",	S_CONDITIONAL,	0,	O_IFIDN	},
    {	NULL,	".ifdif",	S_CONDITIONAL,	0,	O_IFDIF	},
    {	NULL,	".iif",		S_CONDITIONAL,	0,	O_IIF	},
    {	NULL,	".iiff",	S_CONDITIONAL,	0,	O_IIFF	},
    {	NULL,	".iift",	S_CONDITIONAL,	0,	O_IIFT	},
    {	NULL,	".iiftf",	S_CONDITIONAL,	0,	O_IIFTF	},
    {	NULL,	".iifdef",	S_CONDITIONAL,	0,	O_IIFDEF},
    {	NULL,	".iifndef",	S_CONDITIONAL,	0,	O_IIFNDEF},
    {	NULL,	".iifgt",	S_CONDITIONAL,	0,	O_IIFGT	},
    {	NULL,	".iiflt",	S_CONDITIONAL,	0,	O_IIFLT	},
    {	NULL,	".iifge",	S_CONDITIONAL,	0,	O_IIFGE	},
    {	NULL,	".iifle",	S_CONDITIONAL,	0,	O_IIFLE	},
    {	NULL,	".iifeq",	S_CONDITIONAL,	0,	O_IIFEQ	},
    {	NULL,	".iifne",	S_CONDITIONAL,	0,	O_IIFNE	},
    {	NULL,	".iifb",	S_CONDITIONAL,	0,	O_IIFB	},
    {	NULL,	".iifnb",	S_CONDITIONAL,	0,	O_IIFNB	},
    {	NULL,	".iifidn",	S_CONDITIONAL,	0,	O_IIFIDN},
    {	NULL,	".iifdif",	S_CONDITIONAL,	0,	O_IIFDIF},
    {	NULL,	".else",	S_CONDITIONAL,	0,	O_ELSE	},
    {	NULL,	".endif",	S_CONDITIONAL,	0,	O_ENDIF	},
    {	NULL,	".list",	S_LISTING,	0,	O_LIST	},
    {	NULL,	".nlist",	S_LISTING,	0,	O_NLIST	},
    {	NULL,	".equ",		S_EQU,		0,	O_EQU	},
    {	NULL,	".gblequ",	S_EQU,		0,	O_GBLEQU},
    {	NULL,	".lclequ",	S_EQU,		0,	O_LCLEQU},
    {	NULL,	".byte",	S_DATA,		0,	O_1BYTE	},
    {	NULL,	".db",		S_DATA,		0,	O_1BYTE	},
    {	NULL,	".fcb",		S_DATA,		0,	O_1BYTE	},
/*    {	NULL,	".word",	S_DATA,		0,	O_2BYTE	},	*/
/*    {	NULL,	".dw",		S_DATA,		0,	O_2BYTE	},	*/
    {	NULL,	".fdb",		S_DATA,		0,	O_2BYTE	},
    {	NULL,	".3byte",	S_DATA,		0,	O_3BYTE	},
    {	NULL,	".triple",	S_DATA,		0,	O_3BYTE	},
    {	NULL,	".dl",		S_DATA,		0,	O_4BYTE	},
    {	NULL,	".4byte",	S_DATA,		0,	O_4BYTE	},
    {	NULL,	".quad",	S_DATA,		0,	O_4BYTE	},
    {	NULL,	".long",	S_DATA,		0,	O_4BYTE	},
    {	NULL,	".ds",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rmb",		S_BLK,		0,	O_1BYTE	},
    {	NULL,	".rs",		S_BLK,		0,	O_1BYTE	},
/*    {	NULL,	".blkw",	S_BLK,		0,	O_2BYTE	},	*/
    {	NULL,	".blk3",	S_BLK,		0,	O_3BYTE	},
    {	NULL,	".blk4",	S_BLK,		0,	O_4BYTE	},
    {	NULL,	".blkl",	S_BLK,		0,	O_4BYTE	},
    {	NULL,	".blkb",	S_BLK,		0,	O_1BYTE	},
    {	NULL,	".ascii",	S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".ascis",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".asciz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".str",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".strs",	S_ASCIX,	0,	O_ASCIS	},
    {	NULL,	".strz",	S_ASCIX,	0,	O_ASCIZ	},
    {	NULL,	".fcc",		S_ASCIX,	0,	O_ASCII	},
    {	NULL,	".define",	S_DEFINE,	0,	O_DEF	},
    {	NULL,	".undefine",	S_DEFINE,	0,	O_UNDEF	},
    {	NULL,	".even",	S_BOUNDARY,	0,	O_EVEN	},
    {	NULL,	".odd",		S_BOUNDARY,	0,	O_ODD	},
    {	NULL,	".bndry",	S_BOUNDARY,	0,	O_BNDRY	},
    {	NULL,	".msg"	,	S_MSG,		0,	0	},
    {	NULL,	".assume",	S_ERROR,	0,	O_ASSUME},
    {	NULL,	".error",	S_ERROR,	0,	O_ERROR	},
    {	NULL,	".msb",		S_MSB,		0,	0	},
/*    {	NULL,	".lohi",	S_MSB,		0,	O_LOHI	},	*/
/*    {	NULL,	".hilo",	S_MSB,		0,	O_HILO	},	*/
/*    {	NULL,	".8bit",	S_BITS,		0,	O_1BYTE	},	*/
/*    {	NULL,	".16bit",	S_BITS,		0,	O_2BYTE	},	*/
/*    {	NULL,	".24bit",	S_BITS,		0,	O_3BYTE	},	*/
/*    {	NULL,	".32bit",	S_BITS,		0,	O_4BYTE	},	*/
    {	NULL,	".trace",	S_TRACE,	0,	O_TRC	},
    {	NULL,	".ntrace",	S_TRACE,	0,	O_NTRC	},
/*    {	NULL,	"_______",	S_CONST,	0,	VALUE	},	*/
    {	NULL,	".end",		S_END,		0,	0	},

	/* Macro Processor */

    {	NULL,	".macro",	S_MACRO,	0,	O_MACRO	},
    {	NULL,	".endm",	S_MACRO,	0,	O_ENDM	},
    {	NULL,	".mexit",	S_MACRO,	0,	O_MEXIT	},

    {	NULL,	".narg",	S_MACRO,	0,	O_NARG	},
    {	NULL,	".nchr",	S_MACRO,	0,	O_NCHR	},
    {	NULL,	".ntyp",	S_MACRO,	0,	O_NTYP	},

    {	NULL,	".irp",		S_MACRO,	0,	O_IRP	},
    {	NULL,	".irpc",	S_MACRO,	0,	O_IRPC	},
    {	NULL,	".rept",	S_MACRO,	0,	O_REPT	},

    {	NULL,	".nval",	S_MACRO,	0,	O_NVAL	},

    {	NULL,	".mdelete",	S_MACRO,	0,	O_MDEL	},

	/* PPC Redefined Mnemonics */

    {	NULL,	".word",	S_DATA,		0,	O_4BYTE	},
    {	NULL,	".dw",		S_DATA,		0,	O_4BYTE	},
    {	NULL,	".blkw",	S_BLK,		0,	O_4BYTE	},

	/* Machine Specific Directives */

    {	NULL,	".save",	S_AREA,		0,	O_PSH	},
    {	NULL,	".restore",	S_AREA,		0,	O_POP	},

    {	NULL,	".ifdf",	S_CONDITIONAL,	0,	O_IFDEF	},
    {	NULL,	".ifndf",	S_CONDITIONAL,	0,	O_IFNDEF},
    {	NULL,	".iifdf",	S_CONDITIONAL,	0,	O_IIFDEF},
    {	NULL,	".iifndf",	S_CONDITIONAL,	0,	O_IIFNDEF},
    {	NULL,	".endc",	S_CONDITIONAL,	0,	O_ENDIF	},

    {	NULL,	".endr",	S_MACRO,	0,	O_ENDM	},

    {	NULL,	".half",	S_DATA,		0,	O_2BYTE	},
    {	NULL,	".dh",		S_DATA,		0,	O_2BYTE	},
    {	NULL,	".blkh",	S_BLK,		0,	O_2BYTE	},

    {	NULL,	".space",	S_BLK,		0,	O_1BYTE	},

    {	NULL,	".flt16",	W_FLT16,	0,	0	},
    {	NULL,	".flt32",	S_FLT32,	0,	0	},
    {	NULL,	".flt64",	D_FLT64,	0,	0	},

    {	NULL,	".le",		S_ENDIAN,	0,	O_LE	},
    {	NULL,	".be",		S_ENDIAN,	0,	O_BE	},

	/* PowerPC */

    {	NULL,	"cr0",		S_CONST,	0,	O_CR0	},
    {	NULL,	"cr1",		S_CONST,	0,	O_CR1	},
    {	NULL,	"cr2",		S_CONST,	0,	O_CR2	},
    {	NULL,	"cr3",		S_CONST,	0,	O_CR3	},
    {	NULL,	"cr4",		S_CONST,	0,	O_CR4	},
    {	NULL,	"cr5",		S_CONST,	0,	O_CR5	},
    {	NULL,	"cr6",		S_CONST,	0,	O_CR6	},
    {	NULL,	"cr7",		S_CONST,	0,	O_CR7	},
    {	NULL,	"lt",		S_CONST,	0,	O_LT	},
    {	NULL,	"gt",		S_CONST,	0,	O_GT	},
    {	NULL,	"eq",		S_CONST,	0,	O_EQ	},
    {	NULL,	"so",		S_CONST,	0,	O_SO	},

    {	NULL,	"add",		S_ADD,		0,	0x7C000214	},
    {	NULL,	"add.",		S_ADD,		0,	0x7C000215	},
    {	NULL,	"addc",		S_ADD,		0,	0x7C000014	},
    {	NULL,	"addc.",	S_ADD,		0,	0x7C000015	},
    {	NULL,	"addco",	S_ADD,		0,	0x7C000414	},
    {	NULL,	"addco.",	S_ADD,		0,	0x7C000415	},
    {	NULL,	"adde",		S_ADD,		0,	0x7C000114	},
    {	NULL,	"adde.",	S_ADD,		0,	0x7C000115	},
    {	NULL,	"addeo",	S_ADD,		0,	0x7C000514	},
    {	NULL,	"addeo.",	S_ADD,		0,	0x7C000515	},
    {	NULL,	"addi",		S_ADDI,		0,	0x38000000	},
    {	NULL,	"addic",	S_ADDIC,	0,	0x30000000	},
    {	NULL,	"addic.",	S_ADDIC,	0,	0x34000000	},
    {	NULL,	"addis",	S_ADDI,		0,	0x3C000000	},
    {	NULL,	"addme",	S_ADDME,	0,	0x7C0001D4	},
    {	NULL,	"addme.",	S_ADDME,	0,	0x7C0001D5	},
    {	NULL,	"addmeo",	S_ADDME,	0,	0x7C0005D4	},
    {	NULL,	"addmeo.",	S_ADDME,	0,	0x7C0005D5	},
    {	NULL,	"addo",		S_ADD,		0,	0x7C000614	},
    {	NULL,	"addo.",	S_ADD,		0,	0x7C000615	},
    {	NULL,	"addze",	S_ADDME,	0,	0x7C000194	},
    {	NULL,	"addze.",	S_ADDME,	0,	0x7C000195	},
    {	NULL,	"addzeo",	S_ADDME,	0,	0x7C000594	},
    {	NULL,	"addzeo.",	S_ADDME,	0,	0x7C000595	},
    {	NULL,	"and",		S_AND,		0,	0x7C000038	},
    {	NULL,	"and.",		S_AND,		0,	0x7C000039	},
    {	NULL,	"andc",		S_AND,		0,	0x7C000078	},
    {	NULL,	"andc.",	S_AND,		0,	0x7C000079	},
    {	NULL,	"andi.",	S_ANDI,		0,	0x70000000	},
    {	NULL,	"andis.",	S_ANDI,		0,	0x74000000	},
    {	NULL,	"b",		S_B,		0,	0x48000000	},
    {	NULL,	"ba",		S_BA,		0,	0x48000002	},
    {	NULL,	"bc",		S_BC,		0,	0x40000000	},
    {	NULL,	"bca",		S_BCA,		0,	0x40000002	},
    {	NULL,	"bcctr",	S_BCCTR,	0,	0x4C000420	},
    {	NULL,	"bcctre",	S_BCCTRE,	0,	0x4C000422	},
    {	NULL,	"bcctrel",	S_BCCTRE,	0,	0x4C000423	},
    {	NULL,	"bcctrl",	S_BCCTR,	0,	0x4C000421	},
    {	NULL,	"bcl",		S_BC,		0,	0x40000001	},
    {	NULL,	"bcla",		S_BCA,		0,	0x40000003	},
    {	NULL,	"bctr",		S_BCTR,		0,	0x4E800420	},
    {	NULL,	"bctrl",	S_BCTR,		0,	0x4E800421	},
    {	NULL,	"bdnz",		S_BDNZ,		0,	0x42000000	},
    {	NULL,	"bdnza",	S_BDNZA,	0,	0x42000002	},
    {	NULL,	"bdnzf",	S_BDNZF,	0,	0x40000000	},
    {	NULL,	"bdnzfa",	S_BDNZFA,	0,	0x40000002	},
    {	NULL,	"bdnzfl",	S_BDNZF,	0,	0x40000001	},
    {	NULL,	"bdnzfla",	S_BDNZFA,	0,	0x40000003	},
    {	NULL,	"bdnzflr",	S_BDNZFLR,	0,	0x4C000020	},
    {	NULL,	"bdnzflrl",	S_BDNZFLR,	0,	0x4C000021	},
    {	NULL,	"bdnzl",	S_BDNZ,		0,	0x42000001	},
    {	NULL,	"bdnzla",	S_BDNZA,	0,	0x42000003	},
    {	NULL,	"bdnzlr",	S_BDNZLR,	0,	0x4E000020	},
    {	NULL,	"bdnzlrl",	S_BDNZLR,	0,	0x4E000021	},
    {	NULL,	"bdnzt",	S_BDNZF,	0,	0x41000000	},
    {	NULL,	"bdnzta",	S_BDNZFA,	0,	0x41000002	},
    {	NULL,	"bdnztl",	S_BDNZF,	0,	0x41000001	},
    {	NULL,	"bdnztla",	S_BDNZFA,	0,	0x41000003	},
    {	NULL,	"bdnztlr",	S_BDNZFLR,	0,	0x4D000020	},
    {	NULL,	"bdnztlrl",	S_BDNZFLR,	0,	0x4D000021	},
    {	NULL,	"bdz",		S_BDNZ,		0,	0x42400000	},
    {	NULL,	"bdza",		S_BDNZA,	0,	0x42400002	},
    {	NULL,	"bdzf",		S_BDNZF,	0,	0x40400000	},
    {	NULL,	"bdzfa",	S_BDNZFA,	0,	0x40400002	},
    {	NULL,	"bdzfl",	S_BDNZF,	0,	0x40400001	},
    {	NULL,	"bdzfla",	S_BDNZFA,	0,	0x40400003	},
    {	NULL,	"bdzflr",	S_BDNZFLR,	0,	0x4C400020	},
    {	NULL,	"bdzflrl",	S_BDNZFLR,	0,	0x4C400021	},
    {	NULL,	"bdzl",		S_BDNZ,		0,	0x42400001	},
    {	NULL,	"bdzla",	S_BDNZA,	0,	0x42400003	},
    {	NULL,	"bdzlr",	S_BDNZLR,	0,	0x4E400020	},
    {	NULL,	"bdzlrl",	S_BDNZLR,	0,	0x4E400021	},
    {	NULL,	"bdzt",		S_BDNZF,	0,	0x41400000	},
    {	NULL,	"bdzta",	S_BDNZFA,	0,	0x41400002	},
    {	NULL,	"bdztl",	S_BDNZF,	0,	0x41400001	},
    {	NULL,	"bdztla",	S_BDNZFA,	0,	0x41400003	},
    {	NULL,	"bdztlr",	S_BDNZFLR,	0,	0x4D400020	},
    {	NULL,	"bdztlrl",	S_BDNZFLR,	0,	0x4D400021	},
    {	NULL,	"beq",		S_BEQ,		0,	0x41820000	},
    {	NULL,	"beqa",		S_BEQA,		0,	0x41820002	},
    {	NULL,	"beqctr",	S_BEQCTR,	0,	0x4D820420	},
    {	NULL,	"beqctrl",	S_BEQCTR,	0,	0x4D820421	},
    {	NULL,	"beql",		S_BEQ,		0,	0x41820001	},
    {	NULL,	"beqla",	S_BEQA,		0,	0x41820003	},
    {	NULL,	"beqlr",	S_BEQCTR,	0,	0x4D820020	},
    {	NULL,	"beqlrl",	S_BEQCTR,	0,	0x4D820021	},
    {	NULL,	"bge",		S_BEQ,		0,	0x40800000	},
    {	NULL,	"bgea",		S_BEQA,		0,	0x40800002	},
    {	NULL,	"bgectr",	S_BEQCTR,	0,	0x4C800420	},
    {	NULL,	"bgectrl",	S_BEQCTR,	0,	0x4C800421	},
    {	NULL,	"bgel",		S_BEQ,		0,	0x40800001	},
    {	NULL,	"bgela",	S_BEQA,		0,	0x40800003	},
    {	NULL,	"bgelr",	S_BEQCTR,	0,	0x4C800020	},
    {	NULL,	"bgelrl",	S_BEQCTR,	0,	0x4C800021	},
    {	NULL,	"bgt",		S_BEQ,		0,	0x41810000	},
    {	NULL,	"bgta",		S_BEQA,		0,	0x41810002	},
    {	NULL,	"bgtctr",	S_BEQCTR,	0,	0x4D810420	},
    {	NULL,	"bgtctrl",	S_BEQCTR,	0,	0x4D810421	},
    {	NULL,	"bgtl",		S_BEQ,		0,	0x41810001	},
    {	NULL,	"bgtla",	S_BEQA,		0,	0x41810003	},
    {	NULL,	"bgtlr",	S_BEQCTR,	0,	0x4D810020	},
    {	NULL,	"bgtlrl",	S_BEQCTR,	0,	0x4D810021	},
    {	NULL,	"bl",		S_B,		0,	0x48000001	},
    {	NULL,	"bla",		S_BA,		0,	0x48000003	},
    {	NULL,	"ble",		S_BEQ,		0,	0x40810000	},
    {	NULL,	"blea",		S_BEQA,		0,	0x40810002	},
    {	NULL,	"blectr",	S_BEQCTR,	0,	0x4C810420	},
    {	NULL,	"blectrl",	S_BEQCTR,	0,	0x4C810421	},
    {	NULL,	"blel",		S_BEQ,		0,	0x40810001	},
    {	NULL,	"blela",	S_BEQA,		0,	0x40810003	},
    {	NULL,	"blelr",	S_BEQCTR,	0,	0x4C810020	},
    {	NULL,	"blelrl",	S_BEQCTR,	0,	0x4C810021	},
    {	NULL,	"blr",		S_BCTR,		0,	0x4E800020	},
    {	NULL,	"blrl",		S_BCTR,		0,	0x4E800021	},
    {	NULL,	"blt",		S_BEQ,		0,	0x41800000	},
    {	NULL,	"blta",		S_BEQA,		0,	0x41800002	},
    {	NULL,	"bltctr",	S_BEQCTR,	0,	0x4D800420	},
    {	NULL,	"bltctrl",	S_BEQCTR,	0,	0x4D800421	},
    {	NULL,	"bltl",		S_BEQ,		0,	0x41800001	},
    {	NULL,	"bltla",	S_BEQA,		0,	0x41800003	},
    {	NULL,	"bltlr",	S_BEQCTR,	0,	0x4D800020	},
    {	NULL,	"bltlrl",	S_BEQCTR,	0,	0x4D800021	},
    {	NULL,	"bne",		S_BEQ,		0,	0x40820000	},
    {	NULL,	"bnea",		S_BEQA,		0,	0x40820002	},
    {	NULL,	"bnectr",	S_BEQCTR,	0,	0x4C820420	},
    {	NULL,	"bnectrl",	S_BEQCTR,	0,	0x4C820421	},
    {	NULL,	"bnel",		S_BEQ,		0,	0x40820001	},
    {	NULL,	"bnela",	S_BEQA,		0,	0x40820003	},
    {	NULL,	"bnelr",	S_BEQCTR,	0,	0x4C820020	},
    {	NULL,	"bnelrl",	S_BEQCTR,	0,	0x4C820021	},
    {	NULL,	"bns",		S_BEQ,		0,	0x40830000	},
    {	NULL,	"bnsa",		S_BEQA,		0,	0x40830002	},
    {	NULL,	"bnsctr",	S_BEQCTR,	0,	0x4C830420	},
    {	NULL,	"bnsctrl",	S_BEQCTR,	0,	0x4C830421	},
    {	NULL,	"bnsl",		S_BEQ,		0,	0x40830001	},
    {	NULL,	"bnsla",	S_BEQA,		0,	0x40830003	},
    {	NULL,	"bnslr",	S_BEQCTR,	0,	0x4C830020	},
    {	NULL,	"bnslrl",	S_BEQCTR,	0,	0x4C830021	},
    {	NULL,	"bso",		S_BEQ,		0,	0x41830000	},
    {	NULL,	"bsoa",		S_BEQA,		0,	0x41830002	},
    {	NULL,	"bsoctr",	S_BEQCTR,	0,	0x4D830420	},
    {	NULL,	"bsoctrl",	S_BEQCTR,	0,	0x4D830421	},
    {	NULL,	"bsol",		S_BEQ,		0,	0x41830001	},
    {	NULL,	"bsola",	S_BEQA,		0,	0x41830003	},
    {	NULL,	"bsolr",	S_BEQCTR,	0,	0x4D830020	},
    {	NULL,	"bsolrl",	S_BEQCTR,	0,	0x4D830021	},
    {	NULL,	"cli",		S_ADDME,	0,	0x7C0003EC	},
    {	NULL,	"clrldi",	S_CLRLDI,	0,	0x78000000	},
    {	NULL,	"clrldi.",	S_CLRLDI,	0,	0x78000001	},
    {	NULL,	"clrlwi",	S_CLRLWI,	0,	0x5400003E	},
    {	NULL,	"clrlwi.",	S_CLRLWI,	0,	0x5400003F	},
    {	NULL,	"cmpd",		S_CMPD,		0,	0x7C200000	},
    {	NULL,	"cmpdi",	S_CMPDI,	0,	0x2C200000	},
    {	NULL,	"cmpld",	S_CMPD,		0,	0x7C200040	},
    {	NULL,	"cmpldi",	S_CMPLDI,	0,	0x28200000	},
    {	NULL,	"cmplw",	S_CMPD,		0,	0x7C000040	},
    {	NULL,	"cmplwi",	S_CMPLDI,	0,	0x28000000	},
    {	NULL,	"cmpw",		S_CMPD,		0,	0x7C000000	},
    {	NULL,	"cmpwi",	S_CMPDI,	0,	0x2C000000	},
    {	NULL,	"cntlzd",	S_CNTLZD,	0,	0x7C000074	},
    {	NULL,	"cntlzd.",	S_CNTLZD,	0,	0x7C000075	},
    {	NULL,	"cntlzw",	S_CNTLZD,	0,	0x7C000034	},
    {	NULL,	"cntlzw.",	S_CNTLZD,	0,	0x7C000035	},
    {	NULL,	"crand",	S_CRAND,	0,	0x4C000202	},
    {	NULL,	"crandc",	S_CRAND,	0,	0x4C000102	},
    {	NULL,	"crclr",	S_CRCLR,	0,	0x4C000182	},
    {	NULL,	"creqv",	S_CREQV,	0,	0x4C000242	},
    {	NULL,	"crmove",	S_CRMOVE,	0,	0x4C000382	},
    {	NULL,	"crnand",	S_CRAND,	0,	0x4C0001C2	},
    {	NULL,	"crnor",	S_CRNOR,	0,	0x4C000042	},
    {	NULL,	"crnot",	S_CRMOVE,	0,	0x4C000042	},
    {	NULL,	"cror",		S_CRNOR,	0,	0x4C000382	},
    {	NULL,	"crorc",	S_CRAND,	0,	0x4C000342	},
    {	NULL,	"crset",	S_CRCLR,	0,	0x4C000242	},
    {	NULL,	"crxor",	S_CREQV,	0,	0x4C000182	},
    {	NULL,	"dcbf",		S_DCBF,		0,	0x7C0000AC	},
    {	NULL,	"dcbi",		S_DCBF,		0,	0x7C0003AC	},
    {	NULL,	"dcbst",	S_DCBF,		0,	0x7C00006C	},
    {	NULL,	"dcbt",		S_DCBT,		0,	0x7C00022C	},
    {	NULL,	"dcbtst",	S_DCBT,		0,	0x7C0001EC	},
    {	NULL,	"dcbz",		S_DCBF,		0,	0x7C0007EC	},
    {	NULL,	"dcbz128",	S_DCBF,		0,	0x7C2007EC	},
    {	NULL,	"divd",		S_ADD,		0,	0x7C0003D2	},
    {	NULL,	"divd.",	S_ADD,		0,	0x7C0003D3	},
    {	NULL,	"divdo",	S_ADD,		0,	0x7C0007D2	},
    {	NULL,	"divdo.",	S_ADD,		0,	0x7C0007D3	},
    {	NULL,	"divdu",	S_ADD,		0,	0x7C000392	},
    {	NULL,	"divdu.",	S_ADD,		0,	0x7C000393	},
    {	NULL,	"divduo",	S_ADD,		0,	0x7C000792	},
    {	NULL,	"divduo.",	S_ADD,		0,	0x7C000793	},
    {	NULL,	"divw",		S_ADD,		0,	0x7C0003D6	},
    {	NULL,	"divw.",	S_ADD,		0,	0x7C0003D7	},
    {	NULL,	"divwo",	S_ADD,		0,	0x7C0007D6	},
    {	NULL,	"divwo.",	S_ADD,		0,	0x7C0007D7	},
    {	NULL,	"divwu",	S_ADD,		0,	0x7C000396	},
    {	NULL,	"divwu.",	S_ADD,		0,	0x7C000397	},
    {	NULL,	"divwuo",	S_ADD,		0,	0x7C000796	},
    {	NULL,	"divwuo.",	S_ADD,		0,	0x7C000797	},
    {	NULL,	"dss",		S_DSS,		0,	0x7C00066C	},
    {	NULL,	"dssall",	S_DSSALL,	0,	0x7E00066C	},
    {	NULL,	"dst",		S_DST,		0,	0x7C0002AC	},
    {	NULL,	"dstst",	S_DST,		0,	0x7C0002EC	},
    {	NULL,	"dststt",	S_DST,		0,	0x7E0002EC	},
    {	NULL,	"dstt",		S_DST,		0,	0x7E0002AC	},
    {	NULL,	"eciwx",	S_ADD,		0,	0x7C00026C	},
    {	NULL,	"ecowx",	S_ADD,		0,	0x7C00036C	},
    {	NULL,	"eieio",	S_BCTR,		0,	0x7C0006AC	},
    {	NULL,	"eqv",		S_AND,		0,	0x7C000238	},
    {	NULL,	"eqv.",		S_AND,		0,	0x7C000239	},
    {	NULL,	"extsb",	S_CNTLZD,	0,	0x7C000774	},
    {	NULL,	"extsb.",	S_CNTLZD,	0,	0x7C000775	},
    {	NULL,	"extsh",	S_CNTLZD,	0,	0x7C000734	},
    {	NULL,	"extsh.",	S_CNTLZD,	0,	0x7C000735	},
    {	NULL,	"extsw",	S_CNTLZD,	0,	0x7C0007B4	},
    {	NULL,	"extsw.",	S_CNTLZD,	0,	0x7C0007B5	},
    {	NULL,	"fabs",		S_FABS,		0,	0xFC000210	},
    {	NULL,	"fabs.",	S_FABS,		0,	0xFC000211	},
    {	NULL,	"fadd",		S_FADD,		0,	0xFC00002A	},
    {	NULL,	"fadd.",	S_FADD,		0,	0xFC00002B	},
    {	NULL,	"fadds",	S_FADD,		0,	0xEC00002A	},
    {	NULL,	"fadds.",	S_FADD,		0,	0xEC00002B	},
    {	NULL,	"fcfid",	S_FABS,		0,	0xFC00069C	},
    {	NULL,	"fcfid.",	S_FABS,		0,	0xFC00069D	},
    {	NULL,	"fcmpo",	S_FCMPO,	0,	0xFC000040	},
    {	NULL,	"fcmpu",	S_FCMPO,	0,	0xFC000000	},
    {	NULL,	"fctid",	S_FABS,		0,	0xFC00065C	},
    {	NULL,	"fctid.",	S_FABS,		0,	0xFC00065D	},
    {	NULL,	"fctidz",	S_FABS,		0,	0xFC00065E	},
    {	NULL,	"fctidz.",	S_FABS,		0,	0xFC00065F	},
    {	NULL,	"fctiw",	S_FABS,		0,	0xFC00001C	},
    {	NULL,	"fctiw.",	S_FABS,		0,	0xFC00001D	},
    {	NULL,	"fctiwz",	S_FABS,		0,	0xFC00001E	},
    {	NULL,	"fctiwz.",	S_FABS,		0,	0xFC00001F	},
    {	NULL,	"fdiv",		S_FADD,		0,	0xFC000024	},
    {	NULL,	"fdiv.",	S_FADD,		0,	0xFC000025	},
    {	NULL,	"fdivs",	S_FADD,		0,	0xEC000024	},
    {	NULL,	"fdivs.",	S_FADD,		0,	0xEC000025	},
    {	NULL,	"fmadd",	S_FMADD,	0,	0xFC00003A	},
    {	NULL,	"fmadd.",	S_FMADD,	0,	0xFC00003B	},
    {	NULL,	"fmadds",	S_FMADD,	0,	0xEC00003A	},
    {	NULL,	"fmadds.",	S_FMADD,	0,	0xEC00003B	},
    {	NULL,	"fmr",		S_FABS,		0,	0xFC000090	},
    {	NULL,	"fmr.",		S_FABS,		0,	0xFC000091	},
    {	NULL,	"fmsub",	S_FMADD,	0,	0xFC000038	},
    {	NULL,	"fmsub.",	S_FMADD,	0,	0xFC000039	},
    {	NULL,	"fmsubs",	S_FMADD,	0,	0xEC000038	},
    {	NULL,	"fmsubs.",	S_FMADD,	0,	0xEC000039	},
    {	NULL,	"fmul",		S_FMUL,		0,	0xFC000032	},
    {	NULL,	"fmul.",	S_FMUL,		0,	0xFC000033	},
    {	NULL,	"fmuls",	S_FMUL,		0,	0xEC000032	},
    {	NULL,	"fmuls.",	S_FMUL,		0,	0xEC000033	},
    {	NULL,	"fnabs",	S_FABS,		0,	0xFC000110	},
    {	NULL,	"fnabs.",	S_FABS,		0,	0xFC000111	},
    {	NULL,	"fneg",		S_FABS,		0,	0xFC000050	},
    {	NULL,	"fneg.",	S_FABS,		0,	0xFC000051	},
    {	NULL,	"fnmadd",	S_FMADD,	0,	0xFC00003E	},
    {	NULL,	"fnmadd.",	S_FMADD,	0,	0xFC00003F	},
    {	NULL,	"fnmadds",	S_FMADD,	0,	0xEC00003E	},
    {	NULL,	"fnmadds.",	S_FMADD,	0,	0xEC00003F	},
    {	NULL,	"fnmsub",	S_FMADD,	0,	0xFC00003C	},
    {	NULL,	"fnmsub.",	S_FMADD,	0,	0xFC00003D	},
    {	NULL,	"fnmsubs",	S_FMADD,	0,	0xEC00003C	},
    {	NULL,	"fnmsubs.",	S_FMADD,	0,	0xEC00003D	},
    {	NULL,	"fres",		S_FABS,		0,	0xEC000030	},
    {	NULL,	"fres.",	S_FABS,		0,	0xEC000031	},
    {	NULL,	"frsp",		S_FABS,		0,	0xFC000018	},
    {	NULL,	"frsp.",	S_FABS,		0,	0xFC000019	},
    {	NULL,	"frsqrte",	S_FABS,		0,	0xFC000034	},
    {	NULL,	"frsqrte.",	S_FABS,		0,	0xFC000035	},
    {	NULL,	"fsel",		S_FMADD,	0,	0xFC00002E	},
    {	NULL,	"fsel.",	S_FMADD,	0,	0xFC00002F	},
    {	NULL,	"fsqrt",	S_FABS,		0,	0xFC00002C	},
    {	NULL,	"fsqrt.",	S_FABS,		0,	0xFC00002D	},
    {	NULL,	"fsqrts",	S_FABS,		0,	0xEC00002C	},
    {	NULL,	"fsqrts.",	S_FABS,		0,	0xEC00002D	},
    {	NULL,	"fsub",		S_FADD,		0,	0xFC000028	},
    {	NULL,	"fsub.",	S_FADD,		0,	0xFC000029	},
    {	NULL,	"fsubs",	S_FADD,		0,	0xEC000028	},
    {	NULL,	"fsubs.",	S_FADD,		0,	0xEC000029	},
    {	NULL,	"icbi",		S_DCBF,		0,	0x7C0007AC	},
    {	NULL,	"isync",	S_BCTR,		0,	0x4C00012C	},
    {	NULL,	"lbz",		S_LBZ,		0,	0x88000000	},
    {	NULL,	"lbzu",		S_LBZ,		0,	0x8C000000	},
    {	NULL,	"lbzux",	S_ADD,		0,	0x7C0000EE	},
    {	NULL,	"lbzx",		S_ADD,		0,	0x7C0000AE	},
    {	NULL,	"ld",		S_LD,		0,	0xE8000000	},
    {	NULL,	"ldarx",	S_LDARX,	0,	0x7C0000A8	},
    {	NULL,	"ldu",		S_LDU,		0,	0xE8000001	},
    {	NULL,	"ldux",		S_ADD,		0,	0x7C00006A	},
    {	NULL,	"ldx",		S_LDARX,	0,	0x7C00002A	},
    {	NULL,	"lfd",		S_LFD,		0,	0xC8000000	},
    {	NULL,	"lfdu",		S_LFD,		0,	0xCC000000	},
    {	NULL,	"lfdux",	S_LFDUX,	0,	0x7C0004EE	},
    {	NULL,	"lfdx",		S_LFDUX,	0,	0x7C0004AE	},
    {	NULL,	"lfs",		S_LFD,		0,	0xC0000000	},
    {	NULL,	"lfsu",		S_LFD,		0,	0xC4000000	},
    {	NULL,	"lfsux",	S_LFDUX,	0,	0x7C00046E	},
    {	NULL,	"lfsx",		S_LFDUX,	0,	0x7C00042E	},
    {	NULL,	"lha",		S_LBZ,		0,	0xA8000000	},
    {	NULL,	"lhau",		S_LBZ,		0,	0xAC000000	},
    {	NULL,	"lhaux",	S_ADD,		0,	0x7C0002EE	},
    {	NULL,	"lhax",		S_ADD,		0,	0x7C0002AE	},
    {	NULL,	"lhbrx",	S_ADD,		0,	0x7C00062C	},
    {	NULL,	"lhz",		S_LBZ,		0,	0xA0000000	},
    {	NULL,	"lhzu",		S_LBZ,		0,	0xA4000000	},
    {	NULL,	"lhzux",	S_ADD,		0,	0x7C00026E	},
    {	NULL,	"lhzx",		S_ADD,		0,	0x7C00022E	},
    {	NULL,	"li",		S_LI,		0,	0x38000000	},
    {	NULL,	"lis",		S_LI,		0,	0x3C000000	},
    {	NULL,	"lmw",		S_LBZ,		0,	0xB8000000	},
    {	NULL,	"lswi",		S_LSWI,		0,	0x7C0004AA	},
    {	NULL,	"lswx",		S_ADD,		0,	0x7C00042A	},
    {	NULL,	"lvebx",	S_LVEBX,	0,	0x7C00000E	},
    {	NULL,	"lvehx",	S_LVEBX,	0,	0x7C00004E	},
    {	NULL,	"lvewx",	S_LVEBX,	0,	0x7C00008E	},
    {	NULL,	"lvewx128",	S_LVEWX128,	0,	0x10000083	},
    {	NULL,	"lvlx",		S_LVEBX,	0,	0x7C00040E	},
    {	NULL,	"lvlx128",	S_LVEWX128,	0,	0x10000403	},
    {	NULL,	"lvlxl128",	S_LVEWX128,	0,	0x10000603	},
    {	NULL,	"lvrx",		S_LVEBX,	0,	0x7C00044E	},
    {	NULL,	"lvrx128",	S_LVEWX128,	0,	0x10000443	},
    {	NULL,	"lvrxl128",	S_LVEWX128,	0,	0x10000643	},
    {	NULL,	"lvsl",		S_LVEBX,	0,	0x7C00000C	},
    {	NULL,	"lvsl128",	S_LVEWX128,	0,	0x10000003	},
    {	NULL,	"lvsr",		S_LVEBX,	0,	0x7C00004C	},
    {	NULL,	"lvsr128",	S_LVEWX128,	0,	0x10000043	},
    {	NULL,	"lvx",		S_LVEBX,	0,	0x7C0000CE	},
    {	NULL,	"lvx128",	S_LVEWX128,	0,	0x100000C3	},
    {	NULL,	"lvxl",		S_LVEBX,	0,	0x7C0002CE	},
    {	NULL,	"lvxl128",	S_LVEWX128,	0,	0x100002C3	},
    {	NULL,	"lwa",		S_LD,		0,	0xE8000002	},
    {	NULL,	"lwarx",	S_ADD,		0,	0x7C000028	},
    {	NULL,	"lwaux",	S_ADD,		0,	0x7C0002EA	},
    {	NULL,	"lwax",		S_ADD,		0,	0x7C0002AA	},
    {	NULL,	"lwbrx",	S_ADD,		0,	0x7C00042C	},
    {	NULL,	"lwsync",	S_BCTR,		0,	0x7C2004AC	},
    {	NULL,	"lwz",		S_LBZ,		0,	0x80000000	},
    {	NULL,	"lwzu",		S_LBZ,		0,	0x84000000	},
    {	NULL,	"lwzux",	S_ADD,		0,	0x7C00006E	},
    {	NULL,	"lwzx",		S_ADD,		0,	0x7C00002E	},
    {	NULL,	"mcrf",		S_MCRF,		0,	0x4C000000	},
    {	NULL,	"mcrfs",	S_MCRF,		0,	0xFC000080	},
    {	NULL,	"mcrxr",	S_MCRXR,	0,	0x7C000400	},
    {	NULL,	"mfasr",	S_MFASR,	0,	0x7C1842A6	},
    {	NULL,	"mfcr",		S_MFASR,	0,	0x7C000026	},
    {	NULL,	"mfctr",	S_MFASR,	0,	0x7C0902A6	},
    {	NULL,	"mfdar",	S_MFASR,	0,	0x7C1302A6	},
    {	NULL,	"mfdbatl",	S_MFDBATL,	0,	0x7C1982A6	},
    {	NULL,	"mfdbatu",	S_MFDBATL,	0,	0x7C1882A6	},
    {	NULL,	"mfdec",	S_MFDEC,	0,	0x7C0602A6	},
    {	NULL,	"mfdsisr",	S_MFASR,	0,	0x7C1202A6	},
    {	NULL,	"mfear",	S_MFASR,	0,	0x7C1A42A6	},
    {	NULL,	"mffs",		S_MFFS,		0,	0xFC00048E	},
    {	NULL,	"mffs.",	S_MFFS,		0,	0xFC00048F	},
    {	NULL,	"mfibatl",	S_MFDBATL,	0,	0x7C1182A6	},
    {	NULL,	"mfibatu",	S_MFDBATL,	0,	0x7C1082A6	},
    {	NULL,	"mfictc",	S_MFASR,	0,	0x7C1BFAA6	},
    {	NULL,	"mfl2cr",	S_MFASR,	0,	0x7C19FAA6	},
    {	NULL,	"mflr",		S_MFASR,	0,	0x7C0802A6	},
    {	NULL,	"mfmmcr0",	S_MFASR,	0,	0x7C18EAA6	},
    {	NULL,	"mfmmcr1",	S_MFASR,	0,	0x7C1CEAA6	},
    {	NULL,	"mfmsr",	S_MFASR,	0,	0x7C0000A6	},
    {	NULL,	"mfocrf",	S_MFOCRF,	0,	0x7C000026	},
    {	NULL,	"mfpmc1",	S_MFASR,	0,	0x7C19EAA6	},
    {	NULL,	"mfpmc2",	S_MFASR,	0,	0x7C1AEAA6	},
    {	NULL,	"mfpmc3",	S_MFASR,	0,	0x7C1DEAA6	},
    {	NULL,	"mfpmc4",	S_MFASR,	0,	0x7C1EEAA6	},
    {	NULL,	"mfpvr",	S_MFASR,	0,	0x7C1F42A6	},
    {	NULL,	"mfrtcl",	S_MFASR,	0,	0x7C0502A6	},
    {	NULL,	"mfrtcu",	S_MFASR,	0,	0x7C0402A6	},
    {	NULL,	"mfsdr1",	S_MFASR,	0,	0x7C1902A6	},
    {	NULL,	"mfsia",	S_MFASR,	0,	0x7C1BEAA6	},
    {	NULL,	"mfspr",	S_MFSPR,	0,	0x7C0002A6	},
    {	NULL,	"mfsprg",	S_MFSPRG,	0,	0x7C1042A6	},
    {	NULL,	"mfsr",		S_MFSR,		0,	0x7C0004A6	},
    {	NULL,	"mfsrin",	S_MFSRIN,	0,	0x7C000526	},
    {	NULL,	"mfsrr0",	S_MFASR,	0,	0x7C1A02A6	},
    {	NULL,	"mfsrr1",	S_MFASR,	0,	0x7C1B02A6	},
    {	NULL,	"mftb",		S_MFTB,		0,	0x7C0002E6	},
    {	NULL,	"mftbl",	S_MFASR,	0,	0x7C0C42E6	},
    {	NULL,	"mftbu",	S_MFASR,	0,	0x7C0D42E6	},
    {	NULL,	"mfthrm1",	S_MFASR,	0,	0x7C1CFAA6	},
    {	NULL,	"mfthrm2",	S_MFASR,	0,	0x7C1DFAA6	},
    {	NULL,	"mfthrm3",	S_MFASR,	0,	0x7C1EFAA6	},
    {	NULL,	"mfummcr0",	S_MFASR,	0,	0x7C08EAA6	},
    {	NULL,	"mfummcr1",	S_MFASR,	0,	0x7C0CEAA6	},
    {	NULL,	"mfupmc1",	S_MFASR,	0,	0x7C09EAA6	},
    {	NULL,	"mfupmc2",	S_MFASR,	0,	0x7C0AEAA6	},
    {	NULL,	"mfupmc3",	S_MFASR,	0,	0x7C0DEAA6	},
    {	NULL,	"mfupmc4",	S_MFASR,	0,	0x7C0EEAA6	},
    {	NULL,	"mfusia",	S_MFASR,	0,	0x7C0BEAA6	},
    {	NULL,	"mfvrsave",	S_MFASR,	0,	0x7C0042A6	},
    {	NULL,	"mfvscr",	S_MFVSCR,	0,	0x10000604	},
    {	NULL,	"mfxer",	S_MFASR,	0,	0x7C0102A6	},
    {	NULL,	"mr",		S_MR,		0,	0x7C000378	},
    {	NULL,	"mr.",		S_MR,		0,	0x7C000379	},
    {	NULL,	"mtasr",	S_MFASR,	0,	0x7C1843A6	},
    {	NULL,	"mtcr",		S_MFASR,	0,	0x7C0FF120	},
    {	NULL,	"mtcrf",	S_MTCRF,	0,	0x7C000120	},
    {	NULL,	"mtctr",	S_MFASR,	0,	0x7C0903A6	},
    {	NULL,	"mtdar",	S_MFASR,	0,	0x7C1303A6	},
    {	NULL,	"mtdbatl",	S_MTDBATL,	0,	0x7C1983A6	},
    {	NULL,	"mtdbatu",	S_MTDBATL,	0,	0x7C1883A6	},
    {	NULL,	"mtdec",	S_MFASR,	0,	0x7C1603A6	},
    {	NULL,	"mtdsisr",	S_MFASR,	0,	0x7C1203A6	},
    {	NULL,	"mtear",	S_MFASR,	0,	0x7C1A43A6	},
    {	NULL,	"mtfsb0",	S_MTFSB0,	0,	0xFC00008C	},
    {	NULL,	"mtfsb0.",	S_MTFSB0,	0,	0xFC00008D	},
    {	NULL,	"mtfsb1",	S_MTFSB0,	0,	0xFC00004C	},
    {	NULL,	"mtfsb1.",	S_MTFSB0,	0,	0xFC00004D	},
    {	NULL,	"mtfsf",	S_MTFSF,	0,	0xFC00058E	},
    {	NULL,	"mtfsf.",	S_MTFSF,	0,	0xFC00058F	},
    {	NULL,	"mtfsfi",	S_MTFSFI,	0,	0xFC00010C	},
    {	NULL,	"mtfsfi.",	S_MTFSFI,	0,	0xFC00010D	},
    {	NULL,	"mtibatl",	S_MTDBATL,	0,	0x7C1183A6	},
    {	NULL,	"mtibatu",	S_MTDBATL,	0,	0x7C1083A6	},
    {	NULL,	"mtictc",	S_MFASR,	0,	0x7C1BFBA6	},
    {	NULL,	"mtl2cr",	S_MFASR,	0,	0x7C19FBA6	},
    {	NULL,	"mtlr",		S_MFASR,	0,	0x7C0803A6	},
    {	NULL,	"mtmmcr0",	S_MFASR,	0,	0x7C18EBA6	},
    {	NULL,	"mtmmcr1",	S_MFASR,	0,	0x7C1CEBA6	},
    {	NULL,	"mtmsr",	S_MFASR,	0,	0x7C000124	},
    {	NULL,	"mtmsrd",	S_MTMSRD,	0,	0x7C000164	},
    {	NULL,	"mtocrf",	S_MTOCRF,	0,	0x7C100120	},
    {	NULL,	"mtpmc1",	S_MFASR,	0,	0x7C19EBA6	},
    {	NULL,	"mtpmc2",	S_MFASR,	0,	0x7C1AEBA6	},
    {	NULL,	"mtpmc3",	S_MFASR,	0,	0x7C1DEBA6	},
    {	NULL,	"mtpmc4",	S_MFASR,	0,	0x7C1EEBA6	},
    {	NULL,	"mtrtcl",	S_MFASR,	0,	0x7C1503A6	},
    {	NULL,	"mtrtcu",	S_MFASR,	0,	0x7C1403A6	},
    {	NULL,	"mtsdr1",	S_MFASR,	0,	0x7C1903A6	},
    {	NULL,	"mtsia",	S_MFASR,	0,	0x7C1BEBA6	},
    {	NULL,	"mtspr",	S_MTSPR,	0,	0x7C0003A6	},
    {	NULL,	"mtsprg",	S_MTSPRG,	0,	0x7C1043A6	},
    {	NULL,	"mtsr",		S_MTSR,		0,	0x7C0001A4	},
    {	NULL,	"mtsrd",	S_MTSR,		0,	0x7C0000A4	},
    {	NULL,	"mtsrdin",	S_MFSRIN,	0,	0x7C0000E4	},
    {	NULL,	"mtsrin",	S_MFSRIN,	0,	0x7C0001E4	},
    {	NULL,	"mtsrr0",	S_MFASR,	0,	0x7C1A03A6	},
    {	NULL,	"mtsrr1",	S_MFASR,	0,	0x7C1B03A6	},
    {	NULL,	"mttbl",	S_MFASR,	0,	0x7C1C43A6	},
    {	NULL,	"mttbu",	S_MFASR,	0,	0x7C1D43A6	},
    {	NULL,	"mtthrm1",	S_MFASR,	0,	0x7C1CFBA6	},
    {	NULL,	"mtthrm2",	S_MFASR,	0,	0x7C1DFBA6	},
    {	NULL,	"mtthrm3",	S_MFASR,	0,	0x7C1EFBA6	},
    {	NULL,	"mtummcr0",	S_MFASR,	0,	0x7C08EBA6	},
    {	NULL,	"mtummcr1",	S_MFASR,	0,	0x7C0CEBA6	},
    {	NULL,	"mtupmc1",	S_MFASR,	0,	0x7C09EBA6	},
    {	NULL,	"mtupmc2",	S_MFASR,	0,	0x7C0AEBA6	},
    {	NULL,	"mtupmc3",	S_MFASR,	0,	0x7C0DEBA6	},
    {	NULL,	"mtupmc4",	S_MFASR,	0,	0x7C0EEBA6	},
    {	NULL,	"mtusia",	S_MFASR,	0,	0x7C0BEBA6	},
    {	NULL,	"mtvrsave",	S_MFASR,	0,	0x7C0043A6	},
    {	NULL,	"mtvscr",	S_MTVSCR,	0,	0x10000644	},
    {	NULL,	"mtxer",	S_MFASR,	0,	0x7C0103A6	},
    {	NULL,	"mulhd",	S_ADD,		0,	0x7C000092	},
    {	NULL,	"mulhd.",	S_ADD,		0,	0x7C000093	},
    {	NULL,	"mulhdu",	S_ADD,		0,	0x7C000012	},
    {	NULL,	"mulhdu.",	S_ADD,		0,	0x7C000013	},
    {	NULL,	"mulhw",	S_ADD,		0,	0x7C000096	},
    {	NULL,	"mulhw.",	S_ADD,		0,	0x7C000097	},
    {	NULL,	"mulhwu",	S_ADD,		0,	0x7C000016	},
    {	NULL,	"mulhwu.",	S_ADD,		0,	0x7C000017	},
    {	NULL,	"mulld",	S_ADD,		0,	0x7C0001D2	},
    {	NULL,	"mulld.",	S_ADD,		0,	0x7C0001D3	},
    {	NULL,	"mulldo",	S_ADD,		0,	0x7C0005D2	},
    {	NULL,	"mulldo.",	S_ADD,		0,	0x7C0005D3	},
    {	NULL,	"mulli",	S_ADDIC,	0,	0x1C000000	},
    {	NULL,	"mullw",	S_ADD,		0,	0x7C0001D6	},
    {	NULL,	"mullw.",	S_ADD,		0,	0x7C0001D7	},
    {	NULL,	"mullwo",	S_ADD,		0,	0x7C0005D6	},
    {	NULL,	"mullwo.",	S_ADD,		0,	0x7C0005D7	},
    {	NULL,	"nand",		S_AND,		0,	0x7C0003B8	},
    {	NULL,	"nand.",	S_AND,		0,	0x7C0003B9	},
    {	NULL,	"neg",		S_ADDME,	0,	0x7C0000D0	},
    {	NULL,	"neg.",		S_ADDME,	0,	0x7C0000D1	},
    {	NULL,	"nego",		S_ADDME,	0,	0x7C0004D0	},
    {	NULL,	"nego.",	S_ADDME,	0,	0x7C0004D1	},
    {	NULL,	"nop",		S_BCTR,		0,	0x60000000	},
    {	NULL,	"nor",		S_NOR,		0,	0x7C0000F8	},
    {	NULL,	"nor.",		S_NOR,		0,	0x7C0000F9	},
    {	NULL,	"not",		S_MR,		0,	0x7C0000F8	},
    {	NULL,	"not.",		S_MR,		0,	0x7C0000F9	},
    {	NULL,	"or",		S_NOR,		0,	0x7C000378	},
    {	NULL,	"or.",		S_NOR,		0,	0x7C000379	},
    {	NULL,	"orc",		S_AND,		0,	0x7C000338	},
    {	NULL,	"orc.",		S_AND,		0,	0x7C000339	},
    {	NULL,	"ori",		S_ORI,		0,	0x60000000	},
    {	NULL,	"oris",		S_ANDI,		0,	0x64000000	},
    {	NULL,	"ptesync",	S_BCTR,		0,	0x7C4004AC	},
    {	NULL,	"rfi",		S_BCTR,		0,	0x4C000064	},
    {	NULL,	"rfid",		S_BCTR,		0,	0x4C000024	},
    {	NULL,	"rfmci",	S_BCTR,		0,	0x4C00004C	},
    {	NULL,	"rldcl",	S_RLDCL,	0,	0x78000010	},
    {	NULL,	"rldcl.",	S_RLDCL,	0,	0x78000011	},
    {	NULL,	"rldcr",	S_RLDCR,	0,	0x78000012	},
    {	NULL,	"rldcr.",	S_RLDCR,	0,	0x78000013	},
    {	NULL,	"rldic",	S_RLDIC,	0,	0x78000008	},
    {	NULL,	"rldic.",	S_RLDIC,	0,	0x78000009	},
    {	NULL,	"rldicl",	S_RLDIC,	0,	0x78000000	},
    {	NULL,	"rldicl.",	S_RLDIC,	0,	0x78000001	},
    {	NULL,	"rldicr",	S_RLDIC,	0,	0x78000004	},
    {	NULL,	"rldicr.",	S_RLDIC,	0,	0x78000005	},
    {	NULL,	"rldimi",	S_RLDIC,	0,	0x7800000C	},
    {	NULL,	"rldimi.",	S_RLDIC,	0,	0x7800000D	},
    {	NULL,	"rlwimi",	S_RLWIMI,	0,	0x50000000	},
    {	NULL,	"rlwimi.",	S_RLWIMI,	0,	0x50000001	},
    {	NULL,	"rlwinm",	S_RLWIMI,	0,	0x54000000	},
    {	NULL,	"rlwinm.",	S_RLWIMI,	0,	0x54000001	},
    {	NULL,	"rlwnm",	S_RLWNM,	0,	0x5C000000	},
    {	NULL,	"rlwnm.",	S_RLWNM,	0,	0x5C000001	},
    {	NULL,	"rotld",	S_AND,		0,	0x78000010	},
    {	NULL,	"rotld.",	S_AND,		0,	0x78000011	},
    {	NULL,	"rotldi",	S_ROTLDI,	0,	0x78000000	},
    {	NULL,	"rotldi.",	S_ROTLDI,	0,	0x78000001	},
    {	NULL,	"rotlw",	S_AND,		0,	0x5C00003E	},
    {	NULL,	"rotlw.",	S_AND,		0,	0x5C00003F	},
    {	NULL,	"rotlwi",	S_ROTLWI,	0,	0x5400003E	},
    {	NULL,	"rotlwi.",	S_ROTLWI,	0,	0x5400003F	},
    {	NULL,	"sc",		S_BCTR,		0,	0x44000002	},
    {	NULL,	"slbia",	S_BCTR,		0,	0x7C0003E4	},
    {	NULL,	"slbie",	S_SLBIE,	0,	0x7C000364	},
    {	NULL,	"slbmfee",	S_MFSRIN,	0,	0x7C000726	},
    {	NULL,	"slbmfev",	S_MFSRIN,	0,	0x7C0006A6	},
    {	NULL,	"slbmte",	S_MFSRIN,	0,	0x7C000324	},
    {	NULL,	"sld",		S_AND,		0,	0x7C000036	},
    {	NULL,	"sld.",		S_AND,		0,	0x7C000037	},
    {	NULL,	"slw",		S_AND,		0,	0x7C000030	},
    {	NULL,	"slw.",		S_AND,		0,	0x7C000031	},
    {	NULL,	"srad",		S_AND,		0,	0x7C000634	},
    {	NULL,	"srad.",	S_AND,		0,	0x7C000635	},
    {	NULL,	"sradi",	S_ROTLDI,	0,	0x7C000674	},
    {	NULL,	"sradi.",	S_ROTLDI,	0,	0x7C000675	},
    {	NULL,	"sraw",		S_AND,		0,	0x7C000630	},
    {	NULL,	"sraw.",	S_AND,		0,	0x7C000631	},
    {	NULL,	"srawi",	S_ROTLWI,	0,	0x7C000670	},
    {	NULL,	"srawi.",	S_ROTLWI,	0,	0x7C000671	},
    {	NULL,	"srd",		S_AND,		0,	0x7C000436	},
    {	NULL,	"srd.",		S_AND,		0,	0x7C000437	},
    {	NULL,	"srw",		S_AND,		0,	0x7C000430	},
    {	NULL,	"srw.",		S_AND,		0,	0x7C000431	},
    {	NULL,	"stb",		S_LBZ,		0,	0x98000000	},
    {	NULL,	"stbu",		S_LBZ,		0,	0x9C000000	},
    {	NULL,	"stbux",	S_ADD,		0,	0x7C0001EE	},
    {	NULL,	"stbx",		S_ADD,		0,	0x7C0001AE	},
    {	NULL,	"std",		S_LD,		0,	0xF8000000	},
    {	NULL,	"stdcx.",	S_ADD,		0,	0x7C0001AD	},
    {	NULL,	"stdu",		S_LDU,		0,	0xF8000001	},
    {	NULL,	"stdux",	S_ADD,		0,	0x7C00016A	},
    {	NULL,	"stdx",		S_LDARX,	0,	0x7C00012A	},
    {	NULL,	"stfd",		S_LFD,		0,	0xD8000000	},
    {	NULL,	"stfdu",	S_LFD,		0,	0xDC000000	},
    {	NULL,	"stfdux",	S_LFDUX,	0,	0x7C0005EE	},
    {	NULL,	"stfdx",	S_LFDUX,	0,	0x7C0005AE	},
    {	NULL,	"stfiwx",	S_LFDUX,	0,	0x7C0007AE	},
    {	NULL,	"stfs",		S_LFD,		0,	0xD0000000	},
    {	NULL,	"stfsu",	S_LFD,		0,	0xD4000000	},
    {	NULL,	"stfsux",	S_LFDUX,	0,	0x7C00056E	},
    {	NULL,	"stfsx",	S_LFDUX,	0,	0x7C00052E	},
    {	NULL,	"sth",		S_LBZ,		0,	0xB0000000	},
    {	NULL,	"sthbrx",	S_ADD,		0,	0x7C00072C	},
    {	NULL,	"sthu",		S_LBZ,		0,	0xB4000000	},
    {	NULL,	"sthux",	S_ADD,		0,	0x7C00036E	},
    {	NULL,	"sthx",		S_ADD,		0,	0x7C00032E	},
    {	NULL,	"stmw",		S_LBZ,		0,	0xBC000000	},
    {	NULL,	"stswi",	S_LSWI,		0,	0x7C0005AA	},
    {	NULL,	"stswx",	S_ADD,		0,	0x7C00052A	},
    {	NULL,	"stvebx",	S_LVEBX,	0,	0x7C00010E	},
    {	NULL,	"stvehx",	S_LVEBX,	0,	0x7C00014E	},
    {	NULL,	"stvewx",	S_LVEBX,	0,	0x7C00018E	},
    {	NULL,	"stvewx128",	S_LVEWX128,	0,	0x10000183	},
    {	NULL,	"stvlx128",	S_LVEWX128,	0,	0x10000503	},
    {	NULL,	"stvlxl128",	S_LVEWX128,	0,	0x10000703	},
    {	NULL,	"stvrx128",	S_LVEWX128,	0,	0x10000543	},
    {	NULL,	"stvrxl128",	S_LVEWX128,	0,	0x10000743	},
    {	NULL,	"stvx",		S_LVEBX,	0,	0x7C0001CE	},
    {	NULL,	"stvx128",	S_LVEWX128,	0,	0x100001C3	},
    {	NULL,	"stvxl",	S_LVEBX,	0,	0x7C0003CE	},
    {	NULL,	"stvxl128",	S_LVEWX128,	0,	0x100003C3	},
    {	NULL,	"stw",		S_LBZ,		0,	0x90000000	},
    {	NULL,	"stwbrx",	S_ADD,		0,	0x7C00052C	},
    {	NULL,	"stwcx.",	S_ADD,		0,	0x7C00012D	},
    {	NULL,	"stwu",		S_LBZ,		0,	0x94000000	},
    {	NULL,	"stwux",	S_ADD,		0,	0x7C00016E	},
    {	NULL,	"stwx",		S_ADD,		0,	0x7C00012E	},
    {	NULL,	"subf",		S_ADD,		0,	0x7C000050	},
    {	NULL,	"subf.",	S_ADD,		0,	0x7C000051	},
    {	NULL,	"subfc",	S_ADD,		0,	0x7C000010	},
    {	NULL,	"subfc.",	S_ADD,		0,	0x7C000011	},
    {	NULL,	"subfco",	S_ADD,		0,	0x7C000410	},
    {	NULL,	"subfco.",	S_ADD,		0,	0x7C000411	},
    {	NULL,	"subfe",	S_ADD,		0,	0x7C000110	},
    {	NULL,	"subfe.",	S_ADD,		0,	0x7C000111	},
    {	NULL,	"subfeo",	S_ADD,		0,	0x7C000510	},
    {	NULL,	"subfeo.",	S_ADD,		0,	0x7C000511	},
    {	NULL,	"subfic",	S_ADDIC,	0,	0x20000000	},
    {	NULL,	"subfme",	S_ADDME,	0,	0x7C0001D0	},
    {	NULL,	"subfme.",	S_ADDME,	0,	0x7C0001D1	},
    {	NULL,	"subfmeo",	S_ADDME,	0,	0x7C0005D0	},
    {	NULL,	"subfmeo.",	S_ADDME,	0,	0x7C0005D1	},
    {	NULL,	"subfo",	S_ADD,		0,	0x7C000450	},
    {	NULL,	"subfo.",	S_ADD,		0,	0x7C000451	},
    {	NULL,	"subfze",	S_ADDME,	0,	0x7C000190	},
    {	NULL,	"subfze.",	S_ADDME,	0,	0x7C000191	},
    {	NULL,	"subfzeo",	S_ADDME,	0,	0x7C000590	},
    {	NULL,	"subfzeo.",	S_ADDME,	0,	0x7C000591	},
    {	NULL,	"sync",		S_SYNC,		0,	0x7C0004AC	},
    {	NULL,	"td",		S_DCBT,		0,	0x7C000088	},
    {	NULL,	"tdeq",		S_DCBF,		0,	0x7C800088	},
    {	NULL,	"tdeqi",	S_TDEQI,	0,	0x08800000	},
    {	NULL,	"tdge",		S_DCBF,		0,	0x7D800088	},
    {	NULL,	"tdgei",	S_TDEQI,	0,	0x09800000	},
    {	NULL,	"tdgt",		S_DCBF,		0,	0x7D000088	},
    {	NULL,	"tdgti",	S_TDEQI,	0,	0x09000000	},
    {	NULL,	"tdi",		S_TDI,		0,	0x08000000	},
    {	NULL,	"tdle",		S_DCBF,		0,	0x7E800088	},
    {	NULL,	"tdlei",	S_TDEQI,	0,	0x0A800000	},
    {	NULL,	"tdlge",	S_DCBF,		0,	0x7CA00088	},
    {	NULL,	"tdlgei",	S_TDEQI,	0,	0x08A00000	},
    {	NULL,	"tdlgt",	S_DCBF,		0,	0x7C200088	},
    {	NULL,	"tdlgti",	S_TDEQI,	0,	0x08200000	},
    {	NULL,	"tdlle",	S_DCBF,		0,	0x7CC00088	},
    {	NULL,	"tdllei",	S_TDEQI,	0,	0x08C00000	},
    {	NULL,	"tdllt",	S_DCBF,		0,	0x7C400088	},
    {	NULL,	"tdllti",	S_TDEQI,	0,	0x08400000	},
    {	NULL,	"tdlt",		S_DCBF,		0,	0x7E000088	},
    {	NULL,	"tdlti",	S_TDEQI,	0,	0x0A000000	},
    {	NULL,	"tdne",		S_DCBF,		0,	0x7F000088	},
    {	NULL,	"tdnei",	S_TDEQI,	0,	0x0B000000	},
    {	NULL,	"tlbia",	S_BCTR,		0,	0x7C0002E4	},
    {	NULL,	"tlbie",	S_TLBIE,	0,	0x7C000264	},
    {	NULL,	"tlbld",	S_SLBIE,	0,	0x7C0007A4	},
    {	NULL,	"tlbli",	S_SLBIE,	0,	0x7C0007E4	},
    {	NULL,	"tlbsync",	S_BCTR,		0,	0x7C00046C	},
    {	NULL,	"trap",		S_BCTR,		0,	0x7FE00008	},
    {	NULL,	"tw",		S_DCBT,		0,	0x7C000008	},
    {	NULL,	"tweq",		S_DCBF,		0,	0x7C800008	},
    {	NULL,	"tweqi",	S_TDEQI,	0,	0x0C800000	},
    {	NULL,	"twge",		S_DCBF,		0,	0x7D800008	},
    {	NULL,	"twgei",	S_TDEQI,	0,	0x0D800000	},
    {	NULL,	"twgt",		S_DCBF,		0,	0x7D000008	},
    {	NULL,	"twgti",	S_TDEQI,	0,	0x0D000000	},
    {	NULL,	"twi",		S_TDI,		0,	0x0C000000	},
    {	NULL,	"twle",		S_DCBF,		0,	0x7E800008	},
    {	NULL,	"twlei",	S_TDEQI,	0,	0x0E800000	},
    {	NULL,	"twlge",	S_DCBF,		0,	0x7CA00008	},
    {	NULL,	"twlgei",	S_TDEQI,	0,	0x0CA00000	},
    {	NULL,	"twlgt",	S_DCBF,		0,	0x7C200008	},
    {	NULL,	"twlgti",	S_TDEQI,	0,	0x0C200000	},
    {	NULL,	"twlle",	S_DCBF,		0,	0x7CC00008	},
    {	NULL,	"twllei",	S_TDEQI,	0,	0x0CC00000	},
    {	NULL,	"twllt",	S_DCBF,		0,	0x7C400008	},
    {	NULL,	"twllti",	S_TDEQI,	0,	0x0C400000	},
    {	NULL,	"twlt",		S_DCBF,		0,	0x7E000008	},
    {	NULL,	"twlti",	S_TDEQI,	0,	0x0E000000	},
    {	NULL,	"twne",		S_DCBF,		0,	0x7F000008	},
    {	NULL,	"twnei",	S_TDEQI,	0,	0x0F000000	},
    {	NULL,	"vaddcuw",	S_VADDCUW,	0,	0x10000180	},
    {	NULL,	"vaddfp",	S_VADDCUW,	0,	0x1000000A	},
    {	NULL,	"vaddfp128",	S_VADDFP128,	0,	0x14000010	},
    {	NULL,	"vaddsbs",	S_VADDCUW,	0,	0x10000300	},
    {	NULL,	"vaddshs",	S_VADDCUW,	0,	0x10000340	},
    {	NULL,	"vaddsws",	S_VADDCUW,	0,	0x10000380	},
    {	NULL,	"vaddubm",	S_VADDCUW,	0,	0x10000000	},
    {	NULL,	"vaddubs",	S_VADDCUW,	0,	0x10000200	},
    {	NULL,	"vadduhm",	S_VADDCUW,	0,	0x10000040	},
    {	NULL,	"vadduhs",	S_VADDCUW,	0,	0x10000240	},
    {	NULL,	"vadduwm",	S_VADDCUW,	0,	0x10000080	},
    {	NULL,	"vadduws",	S_VADDCUW,	0,	0x10000280	},
    {	NULL,	"vand",		S_VADDCUW,	0,	0x10000404	},
    {	NULL,	"vand128",	S_VADDFP128,	0,	0x14000210	},
    {	NULL,	"vandc",	S_VADDCUW,	0,	0x10000444	},
    {	NULL,	"vandc128",	S_VADDFP128,	0,	0x14000250	},
    {	NULL,	"vavgsb",	S_VADDCUW,	0,	0x10000502	},
    {	NULL,	"vavgsh",	S_VADDCUW,	0,	0x10000542	},
    {	NULL,	"vavgsw",	S_VADDCUW,	0,	0x10000582	},
    {	NULL,	"vavgub",	S_VADDCUW,	0,	0x10000402	},
    {	NULL,	"vavguh",	S_VADDCUW,	0,	0x10000442	},
    {	NULL,	"vavguw",	S_VADDCUW,	0,	0x10000482	},
    {	NULL,	"vcfpsxws128",	S_VCFPSXWS128,	0,	0x18000230	},
    {	NULL,	"vcfpuxws128",	S_VCFPUXWS128,	0,	0x18000270	},
    {	NULL,	"vcfsx",	S_VCFSX,	0,	0x1000034A	},
    {	NULL,	"vcfux",	S_VCFSX,	0,	0x1000030A	},
    {	NULL,	"vcmpbfp",	S_VADDCUW,	0,	0x100003C6	},
    {	NULL,	"vcmpbfp.",	S_VADDCUW,	0,	0x100007C6	},
    {	NULL,	"vcmpbfp128",	S_VADDFP128,	0,	0x18000180	},
    {	NULL,	"vcmpbfp128.",	S_VADDFP128,	0,	0x180001C0	},
    {	NULL,	"vcmpeqfp",	S_VADDCUW,	0,	0x100000C6	},
    {	NULL,	"vcmpeqfp.",	S_VADDCUW,	0,	0x100004C6	},
    {	NULL,	"vcmpeqfp128",	S_VADDFP128,	0,	0x18000000	},
    {	NULL,	"vcmpeqfp128.",	S_VADDFP128,	0,	0x18000040	},
    {	NULL,	"vcmpequb",	S_VADDCUW,	0,	0x10000006	},
    {	NULL,	"vcmpequb.",	S_VADDCUW,	0,	0x10000406	},
    {	NULL,	"vcmpequh",	S_VADDCUW,	0,	0x10000046	},
    {	NULL,	"vcmpequh.",	S_VADDCUW,	0,	0x10000446	},
    {	NULL,	"vcmpequw",	S_VADDCUW,	0,	0x10000086	},
    {	NULL,	"vcmpequw.",	S_VADDCUW,	0,	0x10000486	},
    {	NULL,	"vcmpequw128",	S_VADDFP128,	0,	0x18000200	},
    {	NULL,	"vcmpequw128.",	S_VADDFP128,	0,	0x18000240	},
    {	NULL,	"vcmpgefp",	S_VADDCUW,	0,	0x100001C6	},
    {	NULL,	"vcmpgefp.",	S_VADDCUW,	0,	0x100005C6	},
    {	NULL,	"vcmpgefp128",	S_VADDFP128,	0,	0x18000080	},
    {	NULL,	"vcmpgefp128.",	S_VADDFP128,	0,	0x180000C0	},
    {	NULL,	"vcmpgtfp",	S_VADDCUW,	0,	0x100002C6	},
    {	NULL,	"vcmpgtfp.",	S_VADDCUW,	0,	0x100006C6	},
    {	NULL,	"vcmpgtfp128",	S_VADDFP128,	0,	0x18000100	},
    {	NULL,	"vcmpgtfp128.",	S_VADDFP128,	0,	0x18000140	},
    {	NULL,	"vcmpgtsb",	S_VADDCUW,	0,	0x10000306	},
    {	NULL,	"vcmpgtsb.",	S_VADDCUW,	0,	0x10000706	},
    {	NULL,	"vcmpgtsh",	S_VADDCUW,	0,	0x10000346	},
    {	NULL,	"vcmpgtsh.",	S_VADDCUW,	0,	0x10000746	},
    {	NULL,	"vcmpgtsw",	S_VADDCUW,	0,	0x10000386	},
    {	NULL,	"vcmpgtsw.",	S_VADDCUW,	0,	0x10000786	},
    {	NULL,	"vcmpgtub",	S_VADDCUW,	0,	0x10000206	},
    {	NULL,	"vcmpgtub.",	S_VADDCUW,	0,	0x10000606	},
    {	NULL,	"vcmpgtuh",	S_VADDCUW,	0,	0x10000246	},
    {	NULL,	"vcmpgtuh.",	S_VADDCUW,	0,	0x10000646	},
    {	NULL,	"vcmpgtuw",	S_VADDCUW,	0,	0x10000286	},
    {	NULL,	"vcmpgtuw.",	S_VADDCUW,	0,	0x10000686	},
    {	NULL,	"vcsxwfp128",	S_VCFPSXWS128,	0,	0x180002B0	},
    {	NULL,	"vctsxs",	S_VCFSX,	0,	0x100003CA	},
    {	NULL,	"vctuxs",	S_VCFSX,	0,	0x1000038A	},
    {	NULL,	"vcuxwfp128",	S_VCFPUXWS128,	0,	0x180002F0	},
    {	NULL,	"vexptefp",	S_VEXPTEFP,	0,	0x1000018A	},
    {	NULL,	"vexptefp128",	S_VEXPTEFP128,	0,	0x180006B0	},
    {	NULL,	"vlogefp",	S_VEXPTEFP,	0,	0x100001CA	},
    {	NULL,	"vlogefp128",	S_VEXPTEFP128,	0,	0x180006F0	},
    {	NULL,	"vmaddcfp128",	S_VMADDCFP128,	0,	0x14000110	},
    {	NULL,	"vmaddfp",	S_VMADDFP,	0,	0x1000002E	},
    {	NULL,	"vmaddfp128",	S_VMADDFP128,	0,	0x140000D0	},
    {	NULL,	"vmaxfp",	S_VADDCUW,	0,	0x1000040A	},
    {	NULL,	"vmaxfp128",	S_VADDFP128,	0,	0x18000280	},
    {	NULL,	"vmaxsb",	S_VADDCUW,	0,	0x10000102	},
    {	NULL,	"vmaxsh",	S_VADDCUW,	0,	0x10000142	},
    {	NULL,	"vmaxsw",	S_VADDCUW,	0,	0x10000182	},
    {	NULL,	"vmaxub",	S_VADDCUW,	0,	0x10000002	},
    {	NULL,	"vmaxuh",	S_VADDCUW,	0,	0x10000042	},
    {	NULL,	"vmaxuw",	S_VADDCUW,	0,	0x10000082	},
    {	NULL,	"vmhaddshs",	S_VMHADDSHS,	0,	0x10000020	},
    {	NULL,	"vmhraddshs",	S_VMHADDSHS,	0,	0x10000021	},
    {	NULL,	"vminfp",	S_VADDCUW,	0,	0x1000044A	},
    {	NULL,	"vminfp128",	S_VADDFP128,	0,	0x180002C0	},
    {	NULL,	"vminsb",	S_VADDCUW,	0,	0x10000302	},
    {	NULL,	"vminsh",	S_VADDCUW,	0,	0x10000342	},
    {	NULL,	"vminsw",	S_VADDCUW,	0,	0x10000382	},
    {	NULL,	"vminub",	S_VADDCUW,	0,	0x10000202	},
    {	NULL,	"vminuh",	S_VADDCUW,	0,	0x10000242	},
    {	NULL,	"vminuw",	S_VADDCUW,	0,	0x10000282	},
    {	NULL,	"vmladduhm",	S_VMHADDSHS,	0,	0x10000022	},
    {	NULL,	"vmr",		S_VMR,		0,	0x10000484	},
    {	NULL,	"vmrghb",	S_VADDCUW,	0,	0x1000000C	},
    {	NULL,	"vmrghh",	S_VADDCUW,	0,	0x1000004C	},
    {	NULL,	"vmrghw",	S_VADDCUW,	0,	0x1000008C	},
    {	NULL,	"vmrghw128",	S_VADDFP128,	0,	0x18000300	},
    {	NULL,	"vmrglb",	S_VADDCUW,	0,	0x1000010C	},
    {	NULL,	"vmrglh",	S_VADDCUW,	0,	0x1000014C	},
    {	NULL,	"vmrglw",	S_VADDCUW,	0,	0x1000018C	},
    {	NULL,	"vmrglw128",	S_VADDFP128,	0,	0x18000340	},
    {	NULL,	"vmsum3fp128",	S_VADDFP128,	0,	0x14000190	},
    {	NULL,	"vmsum4fp128",	S_VADDFP128,	0,	0x140001D0	},
    {	NULL,	"vmsummbm",	S_VMHADDSHS,	0,	0x10000025	},
    {	NULL,	"vmsumshm",	S_VMHADDSHS,	0,	0x10000028	},
    {	NULL,	"vmsumshs",	S_VMHADDSHS,	0,	0x10000029	},
    {	NULL,	"vmsumubm",	S_VMHADDSHS,	0,	0x10000024	},
    {	NULL,	"vmsumuhm",	S_VMHADDSHS,	0,	0x10000026	},
    {	NULL,	"vmsumuhs",	S_VMHADDSHS,	0,	0x10000027	},
    {	NULL,	"vmulesb",	S_VADDCUW,	0,	0x10000308	},
    {	NULL,	"vmulesh",	S_VADDCUW,	0,	0x10000348	},
    {	NULL,	"vmuleub",	S_VADDCUW,	0,	0x10000208	},
    {	NULL,	"vmuleuh",	S_VADDCUW,	0,	0x10000248	},
    {	NULL,	"vmulfp128",	S_VADDFP128,	0,	0x14000090	},
    {	NULL,	"vmulosb",	S_VADDCUW,	0,	0x10000108	},
    {	NULL,	"vmulosh",	S_VADDCUW,	0,	0x10000148	},
    {	NULL,	"vmuloub",	S_VADDCUW,	0,	0x10000008	},
    {	NULL,	"vmulouh",	S_VADDCUW,	0,	0x10000048	},
    {	NULL,	"vnmsubfp",	S_VMADDFP,	0,	0x1000002F	},
    {	NULL,	"vnmsubfp128",	S_VMADDFP128,	0,	0x14000150	},
    {	NULL,	"vnor",		S_VNOR,		0,	0x10000504	},
    {	NULL,	"vnor128",	S_VADDFP128,	0,	0x14000290	},
    {	NULL,	"vnot",		S_VMR,		0,	0x10000504	},
    {	NULL,	"vor",		S_VNOR,		0,	0x10000484	},
    {	NULL,	"vor128",	S_VADDFP128,	0,	0x140002D0	},
    {	NULL,	"vperm",	S_VMHADDSHS,	0,	0x1000002B	},
    {	NULL,	"vperm128",	S_VPERM128,	0,	0x14000000	},
    {	NULL,	"vpermwi128",	S_VPERMWI128,	0,	0x18000210	},
    {	NULL,	"vpkd3d128",	S_VPKD3D128,	0,	0x18000610	},
    {	NULL,	"vpkpx",	S_VADDCUW,	0,	0x1000030E	},
    {	NULL,	"vpkshss",	S_VADDCUW,	0,	0x1000018E	},
    {	NULL,	"vpkshss128",	S_VADDFP128,	0,	0x14000200	},
    {	NULL,	"vpkshus",	S_VADDCUW,	0,	0x1000010E	},
    {	NULL,	"vpkshus128",	S_VADDFP128,	0,	0x14000240	},
    {	NULL,	"vpkswss",	S_VADDCUW,	0,	0x100001CE	},
    {	NULL,	"vpkswss128",	S_VADDFP128,	0,	0x14000280	},
    {	NULL,	"vpkswus",	S_VADDCUW,	0,	0x1000014E	},
    {	NULL,	"vpkswus128",	S_VADDFP128,	0,	0x140002C0	},
    {	NULL,	"vpkuhum",	S_VADDCUW,	0,	0x1000000E	},
    {	NULL,	"vpkuhum128",	S_VADDFP128,	0,	0x14000300	},
    {	NULL,	"vpkuhus",	S_VADDCUW,	0,	0x1000008E	},
    {	NULL,	"vpkuhus128",	S_VADDFP128,	0,	0x14000340	},
    {	NULL,	"vpkuwum",	S_VADDCUW,	0,	0x1000004E	},
    {	NULL,	"vpkuwum128",	S_VADDFP128,	0,	0x14000380	},
    {	NULL,	"vpkuwus",	S_VADDCUW,	0,	0x100000CE	},
    {	NULL,	"vpkuwus128",	S_VADDFP128,	0,	0x140003C0	},
    {	NULL,	"vrefp",	S_VEXPTEFP,	0,	0x1000010A	},
    {	NULL,	"vrefp128",	S_VEXPTEFP128,	0,	0x18000630	},
    {	NULL,	"vrfim",	S_VEXPTEFP,	0,	0x100002CA	},
    {	NULL,	"vrfim128",	S_VEXPTEFP128,	0,	0x18000330	},
    {	NULL,	"vrfin",	S_VEXPTEFP,	0,	0x1000020A	},
    {	NULL,	"vrfin128",	S_VEXPTEFP128,	0,	0x18000370	},
    {	NULL,	"vrfip",	S_VEXPTEFP,	0,	0x1000028A	},
    {	NULL,	"vrfip128",	S_VEXPTEFP128,	0,	0x180003B0	},
    {	NULL,	"vrfiz",	S_VEXPTEFP,	0,	0x1000024A	},
    {	NULL,	"vrfiz128",	S_VEXPTEFP128,	0,	0x180003F0	},
    {	NULL,	"vrlb",		S_VADDCUW,	0,	0x10000004	},
    {	NULL,	"vrlh",		S_VADDCUW,	0,	0x10000044	},
    {	NULL,	"vrlimi128",	S_VRLIMI128,	0,	0x18000710	},
    {	NULL,	"vrlw",		S_VADDCUW,	0,	0x10000084	},
    {	NULL,	"vrlw128",	S_VADDFP128,	0,	0x18000050	},
    {	NULL,	"vrsqrtefp",	S_VEXPTEFP,	0,	0x1000014A	},
    {	NULL,	"vsel",		S_VMHADDSHS,	0,	0x1000002A	},
    {	NULL,	"vsel128",	S_VMADDFP128,	0,	0x14000350	},
    {	NULL,	"vsl",		S_VADDCUW,	0,	0x100001C4	},
    {	NULL,	"vslb",		S_VADDCUW,	0,	0x10000104	},
    {	NULL,	"vsldoi",	S_VSLDOI,	0,	0x1000002C	},
    {	NULL,	"vsldoi128",	S_VSLDOI128,	0,	0x10000010	},
    {	NULL,	"vslh",		S_VADDCUW,	0,	0x10000144	},
    {	NULL,	"vslo",		S_VADDCUW,	0,	0x1000040C	},
    {	NULL,	"vslo128",	S_VADDFP128,	0,	0x14000390	},
    {	NULL,	"vslw",		S_VADDCUW,	0,	0x10000184	},
    {	NULL,	"vslw128",	S_VADDFP128,	0,	0x180000D0	},
    {	NULL,	"vspltb",	S_VCFSX,	0,	0x1000020C	},
    {	NULL,	"vsplth",	S_VCFSX,	0,	0x1000024C	},
    {	NULL,	"vspltisb",	S_VSPLTISB,	0,	0x1000030C	},
    {	NULL,	"vspltish",	S_VSPLTISB,	0,	0x1000034C	},
    {	NULL,	"vspltisw",	S_VSPLTISB,	0,	0x1000038C	},
    {	NULL,	"vspltisw128",	S_VCFPSXWS128,	0,	0x18000770	},
    {	NULL,	"vspltw",	S_VCFSX,	0,	0x1000028C	},
    {	NULL,	"vspltw128",	S_VCFPUXWS128,	0,	0x18000730	},
    {	NULL,	"vsr",		S_VADDCUW,	0,	0x100002C4	},
    {	NULL,	"vsrab",	S_VADDCUW,	0,	0x10000304	},
    {	NULL,	"vsrah",	S_VADDCUW,	0,	0x10000344	},
    {	NULL,	"vsraw",	S_VADDCUW,	0,	0x10000384	},
    {	NULL,	"vsraw128",	S_VADDFP128,	0,	0x18000150	},
    {	NULL,	"vsrb",		S_VADDCUW,	0,	0x10000204	},
    {	NULL,	"vsrh",		S_VADDCUW,	0,	0x10000244	},
    {	NULL,	"vsro",		S_VADDCUW,	0,	0x1000044C	},
    {	NULL,	"vsro128",	S_VADDFP128,	0,	0x140003D0	},
    {	NULL,	"vsrw",		S_VADDCUW,	0,	0x10000284	},
    {	NULL,	"vsrw128",	S_VADDFP128,	0,	0x180001D0	},
    {	NULL,	"vsubcuw",	S_VADDCUW,	0,	0x10000580	},
    {	NULL,	"vsubfp",	S_VADDCUW,	0,	0x1000004A	},
    {	NULL,	"vsubfp128",	S_VADDFP128,	0,	0x14000050	},
    {	NULL,	"vsubsbs",	S_VADDCUW,	0,	0x10000700	},
    {	NULL,	"vsubshs",	S_VADDCUW,	0,	0x10000740	},
    {	NULL,	"vsubsws",	S_VADDCUW,	0,	0x10000780	},
    {	NULL,	"vsububm",	S_VADDCUW,	0,	0x10000400	},
    {	NULL,	"vsububs",	S_VADDCUW,	0,	0x10000600	},
    {	NULL,	"vsubuhm",	S_VADDCUW,	0,	0x10000440	},
    {	NULL,	"vsubuhs",	S_VADDCUW,	0,	0x10000640	},
    {	NULL,	"vsubuwm",	S_VADDCUW,	0,	0x10000480	},
    {	NULL,	"vsubuws",	S_VADDCUW,	0,	0x10000680	},
    {	NULL,	"vsum2sws",	S_VADDCUW,	0,	0x10000688	},
    {	NULL,	"vsum4sbs",	S_VADDCUW,	0,	0x10000708	},
    {	NULL,	"vsum4shs",	S_VADDCUW,	0,	0x10000648	},
    {	NULL,	"vsum4ubs",	S_VADDCUW,	0,	0x10000608	},
    {	NULL,	"vsumsws",	S_VADDCUW,	0,	0x10000788	},
    {	NULL,	"vupkd3d128",	S_VCFPUXWS128,	0,	0x180007F0	},
    {	NULL,	"vupkhpx",	S_VEXPTEFP,	0,	0x1000034E	},
    {	NULL,	"vupkhsb",	S_VEXPTEFP,	0,	0x1000020E	},
    {	NULL,	"vupkhsb128",	S_VUPKHSB128,	0,	0x18000380	},
    {	NULL,	"vupkhsh",	S_VEXPTEFP,	0,	0x1000024E	},
    {	NULL,	"vupklpx",	S_VEXPTEFP,	0,	0x100003CE	},
    {	NULL,	"vupklsb",	S_VEXPTEFP,	0,	0x1000028E	},
    {	NULL,	"vupklsb128",	S_VUPKHSB128,	0,	0x180003C0	},
    {	NULL,	"vupklsh",	S_VEXPTEFP,	0,	0x100002CE	},
    {	NULL,	"vxor",		S_VADDCUW,	0,	0x100004C4	},
    {	NULL,	"vxor128",	S_VADDFP128,	0,	0x14000310	},
    {	NULL,	"xor",		S_AND,		0,	0x7C000278	},
    {	NULL,	"xor.",		S_AND,		0,	0x7C000279	},
    {	NULL,	"xori",		S_ANDI,		0,	0x68000000	},
    {	NULL,	"xoris",	S_ANDI,		S_EOL,	0x6C000000	},

};
